<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

/**
 * 代码高亮插件
 *
 * @package 代码高亮插件
 * @author 虾米菌
 * @version 1.0.0
 * @link https://www.wulalalala.com/
 */
class Highlight_Plugin implements Typecho_Plugin_Interface{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate(){
        Typecho_Plugin::factory('Widget_Archive')->header = array('Highlight_Plugin', 'prism');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){
    }

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form){
//        /** 分类名称 */
//        $name = new Typecho_Widget_Helper_Form_Element_Text('word', NULL, 'Hello World', _t('说点什么'));
//        $form->addInput($name);
    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){
    }

    /**
     * 插件实现方法
     *
     * @access public
     * @return void
     */
    public static function prism(){
        $plugin_path = Helper::options()->pluginUrl;
        echo "\n<!--  代码高亮插件Star  -->\n";
        echo "<link href='" . $plugin_path . "/Highlight/prism.css?201804261553' rel='stylesheet' />\n";
        echo "<script src='" . $plugin_path . "/Highlight/prism.js?201804261553'></script>";
        echo "\n<!--  代码高亮插件End  -->\n";
    }
}
